/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.roles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.roles.SubGuiNpcJobHealerSettings;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobHealer;
import noppes.npcs.roles.data.HealerSettings;

public class GuiNpcHealer
extends GuiNPCInterface2
implements ISubGuiListener,
ITextfieldListener,
ICustomScrollListener {
    private final Map<String, String> displays_0 = new TreeMap<String, String>();
    private final Map<String, String> displays_1 = new TreeMap<String, String>();
    private final Map<String, Integer> potions = new TreeMap<String, Integer>();
    private final JobHealer job;
    private int range = 8;
    private int speed = 10;
    private int amplifier = 0;
    private byte type = (byte)2;
    private GuiCustomScroll options;
    private GuiCustomScroll configured;

    public GuiNpcHealer(EntityNPCInterface npc) {
        super(npc);
        this.job = (JobHealer)npc.advanced.jobInterface;
        for (Potion p : Potion.field_188414_b) {
            this.potions.put(p.func_76393_a(), Potion.func_188409_a((Potion)p));
        }
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                if (!this.configured.hasSelected()) {
                    return;
                }
                int id = this.potions.get(this.displays_1.get(this.configured.getSelected()));
                if (!this.job.effects.containsKey(id)) {
                    return;
                }
                this.setSubGui(new SubGuiNpcJobHealerSettings(0, this.job.effects.get(id)));
                break;
            }
            case 1: {
                this.type = (byte)button.getValue();
                break;
            }
            case 11: {
                if (!this.options.hasSelected()) {
                    return;
                }
                GuiNpcTextField.unfocus();
                int id = this.potions.get(this.displays_0.get(this.options.getSelected()));
                HealerSettings hs = new HealerSettings(id, this.range, this.speed, this.amplifier, this.type);
                this.job.effects.put(id, hs);
                this.options.setSelect(-1);
                this.configured.setSelect(-1);
                this.func_73866_w_();
                break;
            }
            case 12: {
                if (!this.configured.hasSelected()) {
                    return;
                }
                this.job.effects.remove(this.potions.get(this.displays_1.get(this.configured.getSelected())));
                this.options.setSelect(-1);
                this.configured.setSelect(-1);
                this.func_73866_w_();
                break;
            }
            case 13: {
                GuiNpcTextField.unfocus();
                this.job.effects.clear();
                for (Potion p : Potion.field_188414_b) {
                    int id = Potion.func_188409_a((Potion)p);
                    HealerSettings hs = new HealerSettings(id, this.range, this.speed, this.amplifier, this.type);
                    this.job.effects.put(id, hs);
                }
                this.options.setSelect(-1);
                this.configured.setSelect(-1);
                this.func_73866_w_();
                break;
            }
            case 14: {
                this.job.effects.clear();
                this.options.setSelect(-1);
                this.configured.setSelect(-1);
                this.func_73866_w_();
            }
        }
    }

    @Override
    public void elementClicked() {
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int y = this.guiTop + 14;
        if (this.options == null) {
            this.options = new GuiCustomScroll(this, 0);
            this.options.setSize(172, 154);
        }
        this.options.guiLeft = this.guiLeft + 4;
        this.options.guiTop = y;
        this.addScroll(this.options);
        this.addLabel(new GuiNpcLabel(11, "beacon.availableEffects", this.guiLeft + 4, y - 10));
        if (this.configured == null) {
            this.configured = new GuiCustomScroll(this, 1);
            this.configured.setSize(172, 154);
        }
        this.configured.guiLeft = this.guiLeft + 238;
        this.configured.guiTop = y;
        this.addScroll(this.configured);
        this.addLabel(new GuiNpcLabel(12, "beacon.currentEffects", this.guiLeft + 235, y - 10));
        this.displays_0.clear();
        this.displays_1.clear();
        LinkedHashMap<Integer, List<String>> htsO = new LinkedHashMap<Integer, List<String>>();
        LinkedHashMap<Integer, List<String>> htsC = new LinkedHashMap<Integer, List<String>>();
        TextComponentTranslation r = new TextComponentTranslation("gui.range", new Object[0]);
        TextComponentTranslation s = new TextComponentTranslation("gui.repeatable", new Object[0]);
        TextComponentTranslation b = new TextComponentTranslation("gui.blocks", new Object[0]);
        TextComponentTranslation c = new TextComponentTranslation("gui.sec", new Object[0]);
        TextComponentTranslation t = new TextComponentTranslation("gui.time", new Object[0]);
        TextComponentTranslation p = new TextComponentTranslation("beacon.amplifier", new Object[0]);
        TextComponentTranslation l = new TextComponentTranslation("parameter.level", new Object[0]);
        TextComponentTranslation j = new TextComponentTranslation("gui.type", new Object[0]);
        TextComponentTranslation u = new TextComponentTranslation("script.target", new Object[0]);
        r.func_150256_b().func_150238_a(TextFormatting.GRAY);
        s.func_150256_b().func_150238_a(TextFormatting.GRAY);
        c.func_150256_b().func_150238_a(TextFormatting.GRAY);
        b.func_150256_b().func_150238_a(TextFormatting.GRAY);
        t.func_150256_b().func_150238_a(TextFormatting.GRAY);
        p.func_150256_b().func_150238_a(TextFormatting.GRAY);
        l.func_150256_b().func_150238_a(TextFormatting.GRAY);
        j.func_150256_b().func_150238_a(TextFormatting.GRAY);
        u.func_150256_b().func_150238_a(TextFormatting.GRAY);
        for (String pointName : this.potions.keySet()) {
            int id = this.potions.get(pointName);
            Potion potion = Potion.func_188412_a((int)id);
            String name = '\u00a7' + (potion == null ? "5" : (potion.func_76398_f() ? "c" : "a")) + new TextComponentTranslation(pointName, new Object[0]).func_150254_d();
            if (!this.job.effects.containsKey(id)) {
                this.displays_0.put(name, pointName);
                htsO.put(htsO.size(), Collections.singletonList("ID: \u00a76" + id));
                continue;
            }
            HealerSettings hs = this.job.effects.get(id);
            String lv = "enchantment.level." + hs.amplifier;
            lv = !new TextComponentTranslation(lv, new Object[0]).func_150254_d().equals(lv) ? new TextComponentTranslation(lv, new Object[0]).func_150254_d() : "" + (hs.amplifier + 1);
            this.displays_1.put(name + " " + lv, pointName);
            TextComponentTranslation f = new TextComponentTranslation(hs.type == 0 ? "faction.friendly" : (hs.type == 1 ? "faction.unfriendly" : "spawner.all"), new Object[0]);
            f.func_150256_b().func_150238_a(hs.type == 0 ? TextFormatting.GREEN : TextFormatting.DARK_AQUA);
            TextComponentTranslation h = new TextComponentTranslation(hs.isMassive ? "beacon.massive" : "beacon.not.massive", new Object[0]);
            h.func_150256_b().func_150238_a(hs.isMassive ? TextFormatting.DARK_PURPLE : TextFormatting.YELLOW);
            ArrayList<String> hovers = new ArrayList<String>();
            hovers.add("ID: \u00a76" + id);
            hovers.add(r.func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "e" + hs.range + " " + b.func_150254_d());
            hovers.add(s.func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "b" + (double)Math.round((double)hs.speed / 2.0) / 10.0 + " " + c.func_150254_d());
            hovers.add(t.func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "a" + (double)Math.round((double)hs.time / 2.0) / 10.0 + " " + c.func_150254_d());
            hovers.add(p.func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "c" + (hs.amplifier + 1) + " " + l.func_150254_d());
            hovers.add(j.func_150254_d() + '\u00a7' + "7: " + f.func_150254_d());
            hovers.add(u.func_150254_d() + '\u00a7' + "7: " + h.func_150254_d());
            htsC.put(htsC.size(), hovers);
        }
        this.options.setListNotSorted(new ArrayList<String>(this.displays_0.keySet()));
        this.options.setHoverTexts(htsO);
        this.configured.setListNotSorted(new ArrayList<String>(this.displays_1.keySet()));
        this.configured.setHoverTexts(htsC);
        TextComponentTranslation toall = new TextComponentTranslation("beacon.hover.toall", new Object[0]);
        this.addLabel(new GuiNpcLabel(1, "beacon.range", this.guiLeft + 10, (y += 156) + 5));
        GuiNpcTextField textField = new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 80, y, 40, 20, this.range + "");
        textField.setMinMaxDefault(1L, 64L, 16L);
        textField.setHoverText(new TextComponentTranslation("beacon.hover.dist", new Object[0]).func_150257_a((ITextComponent)toall).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(2, "stats.speed", this.guiLeft + 140, y + 5));
        textField = new GuiNpcTextField(2, this, this.field_146289_q, this.guiLeft + 220, y, 40, 20, this.speed + "");
        textField.setMinMaxDefault(10L, 72000L, 20L);
        textField.setHoverText(new TextComponentTranslation("beacon.hover.speed", new Object[0]).func_150257_a((ITextComponent)toall).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(3, "beacon.affect", this.guiLeft + 10, (y += 22) + 5));
        GuiNpcButton button = new GuiNpcButton(1, this.guiLeft + 56, y, 80, 20, new String[]{"faction.friendly", "faction.unfriendly", "spawner.all"}, this.type);
        button.setHoverText(new TextComponentTranslation("beacon.hover.type", new Object[0]).func_150257_a((ITextComponent)toall).func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(4, "beacon.amplifier", this.guiLeft + 140, y + 5));
        textField = new GuiNpcTextField(3, this, this.field_146289_q, this.guiLeft + 220, y, 40, 20, this.amplifier + 1 + "");
        textField.setMinMaxDefault(1L, 4L, 1L);
        String lv = "enchantment.level." + this.amplifier;
        lv = !new TextComponentTranslation(lv, new Object[0]).func_150254_d().equals(lv) ? new TextComponentTranslation(lv, new Object[0]).func_150254_d() : "" + (this.amplifier + 1);
        textField.setHoverText(new TextComponentTranslation("beacon.hover.power", new Object[]{lv}).func_150257_a((ITextComponent)toall).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        y -= 198;
        button = new GuiNpcButton(11, this.guiLeft + 177, y += 33, 61, 20, ">");
        button.setEnabled(this.options.hasSelected());
        button.setHoverText("beacon.hover.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(12, this.guiLeft + 177, y += 22, 61, 20, "<");
        button.setEnabled(this.configured.hasSelected());
        button.setHoverText("beacon.hover.del", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(13, this.guiLeft + 177, y += 44, 61, 20, ">>");
        button.setEnabled(!this.displays_0.isEmpty());
        button.setHoverText("beacon.hover.add.all", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(14, this.guiLeft + 177, y += 22, 61, 20, "<<");
        button.setEnabled(!this.displays_1.isEmpty());
        button.setHoverText("beacon.hover.del.all", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(0, this.guiLeft + 177, y + 33, 61, 20, "gui.edit");
        button.setEnabled(this.configured.hasSelected());
        button.setHoverText("beacon.hover.edit", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void save() {
        Client.sendData(EnumPacketServer.JobSave, this.job.save(new NBTTagCompound()));
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 && this.subgui == null) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAdvanced);
            return;
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (!(subgui instanceof SubGuiNpcJobHealerSettings) || !this.configured.hasSelected()) {
            return;
        }
        int id = this.potions.get(this.displays_1.get(this.configured.getSelected()));
        this.job.effects.put(id, ((SubGuiNpcJobHealerSettings)subgui).hs);
        this.func_73866_w_();
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        if (scroll.getID() == 0) {
            if (!this.options.hasSelected()) {
                return;
            }
            GuiNpcTextField.unfocus();
            int id = this.potions.get(this.displays_0.get(this.options.getSelected()));
            HealerSettings hs = new HealerSettings(id, this.range, this.speed, this.amplifier, this.type);
            this.job.effects.put(id, hs);
            this.options.setSelect(-1);
            this.configured.setSelect(-1);
            this.func_73866_w_();
        } else {
            if (!this.configured.hasSelected()) {
                return;
            }
            int id = this.potions.get(this.displays_1.get(this.configured.getSelected()));
            if (!this.job.effects.containsKey(id)) {
                return;
            }
            this.setSubGui(new SubGuiNpcJobHealerSettings(0, this.job.effects.get(id)));
        }
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        switch (textField.getID()) {
            case 1: {
                this.range = textField.getInteger();
                break;
            }
            case 2: {
                this.speed = textField.getInteger();
                break;
            }
            case 3: {
                this.amplifier = textField.getInteger() - 1;
            }
        }
    }
}

